/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.preferences.PreferencesLookupDelegate;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.text.edits.TextEdit;

public class CommonFormatterUtils {
    public static String format(IPath filePath, String input) {
        IScriptFormatterFactory factory;
        if (filePath == null || input == null || input.trim().length() == 0) {
            return input;
        }
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(filePath.lastSegment());
        if (contentType != null && (factory = ScriptFormatterManager.getSelected((String)contentType.getId())) != null) {
            Document document = new Document(input);
            IPartitioningConfiguration partitioningConfiguration = (IPartitioningConfiguration)factory.getPartitioningConfiguration();
            CompositePartitionScanner partitionScanner = new CompositePartitionScanner(partitioningConfiguration.createSubPartitionScanner(), new NullSubPartitionScanner(), new NullPartitionerSwitchStrategy());
            ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, partitioningConfiguration.getContentTypes());
            partitionScanner.setPartitioner(partitioner);
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            IResource parentResource = ResourcesPlugin.getWorkspace().getRoot().findMember(filePath.removeLastSegments(1));
            if (parentResource != null) {
                IProject project = parentResource.getProject();
                Map preferences = factory.retrievePreferences(new PreferencesLookupDelegate(project));
                TextEdit formattedTextEdit = factory.createFormatter(lineDelimiter, preferences).format(input, 0, input.length(), 0, false, null, "");
                try {
                    formattedTextEdit.apply((IDocument)document);
                    input = document.get();
                }
                catch (Exception e) {
                    IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)"Error while formatting the file template code", (Throwable)e);
                }
            }
        }
        return input;
    }
}

